<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $__env->yieldContent('title', config('app.name')); ?></title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>
<body class="font-sans antialiased">
    <div class="min-h-screen bg-gray-100 flex flex-col justify-center py-12 sm:px-6 lg:px-8">
        <div class="sm:mx-auto sm:w-full sm:max-w-4xl">
            <div class="lg:grid lg:grid-cols-2 lg:gap-16 items-center">
                <!-- Left Column: Branding -->
                <div class="text-center lg:text-left px-4 lg:px-0">
                    <h1 class="text-5xl font-bold text-blue-600"><?php echo e(config('app.name', 'Laravel')); ?></h1>
                    <p class="mt-4 text-2xl text-gray-700">
                        Connect with friends and the world around you on <?php echo e(config('app.name', 'Laravel')); ?>.
                    </p>
                </div>

                <!-- Right Column: Form Slot -->
                <div class="mt-8 sm:mx-auto sm:w-full sm:max-w-md">
                    <?php echo e($slot); ?>

                </div>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\product-authentication-system2\resources\views/layouts/guest.blade.php ENDPATH**/ ?>