    

    <?php $__env->startSection('content'); ?>
        <div class="container mx-auto px-4 py-8">
            <!-- Print Controls -->
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <div class="flex justify-between items-center">
                    <h1 class="text-2xl font-bold text-gray-800">Authenticity Sticker Printing</h1>
                    <button onclick="window.print()"
                        class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg flex items-center">
                        <i class="fas fa-print mr-2"></i> Print Stickers
                    </button>
                </div>

                <!-- Print Settings Form -->
                <form method="GET" action="<?php echo e(route('sticker.print')); ?>" class="mt-4 grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Starting Serial Number</label>
                        <input type="text" name="serial_no" value="<?php echo e($serialNo); ?>" placeholder="e.g., INT-2301-200601"
                            class="w-full px-3 py-2  rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Number of Stickers</label>
                        <select name="quantity"
                            class="w-full px-3 py-2  rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="40" <?php echo e($quantity == 40 ? 'selected' : ''); ?>>40 Stickers (1 Page)</option>
                            <option value="80" <?php echo e($quantity == 80 ? 'selected' : ''); ?>>80 Stickers (2 Pages)</option>
                            <option value="120" <?php echo e($quantity == 120 ? 'selected' : ''); ?>>120 Stickers (3 Pages)</option>
                            <option value="160" <?php echo e($quantity == 160 ? 'selected' : ''); ?>>160 Stickers (4 Pages)</option>
                        </select>
                    </div>
                    <div class="flex items-end">
                        <button type="submit"
                            class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded-lg w-full">
                            Generate Stickers
                        </button>
                    </div>
                </form>
            </div>

            <!-- Sticker Printing Area -->
            <div class="print-area">
                <?php
                    $startSerial = $serialNo ? intval(substr($serialNo, -6)) : 200601;
                    $totalStickers = $quantity;
                    $stickersPerPage = 40; // Adjusted to 5x8 grid (40 stickers)
                    $totalPages = ceil($totalStickers / $stickersPerPage);
                ?>

                <?php for($page = 0; $page < $totalPages; $page++): ?>
                    <div class="page break-after-page">
                        <div class="grid grid-cols-5 grid-rows-8 gap-1 p-1 h-[297mm] w-[210mm] mx-auto bg-white">
                            <?php for($i = 0; $i < $stickersPerPage; $i++): ?>
                                <?php
                                    $stickerIndex = $page * $stickersPerPage + $i;
                                    if ($stickerIndex >= $totalStickers) {
                                        break;
                                    }

                                    $serialNumber = $startSerial + $stickerIndex;
                                    $serialCode = 'INT-2301-' . str_pad($serialNumber, 6, '0', STR_PAD_LEFT);

                                    $qrData = urlencode('https://your-verification-domain.com/verify?serial=' . $serialCode);
                                    $barcodeURL = 'https://bwipjs-api.metafloor.com/?bcid=code128&text=' . urlencode($serialCode) . '&scale=4&includetext=true&backgroundcolor=FFFFFF';
                                    $qrURL = 'https://api.qrserver.com/v1/create-qr-code/?size=400x400&data=' . $qrData;
                                ?>

                                <div class="sticker-wrapper flex rounded">
                                    <div class="sticker flex-1 flex flex-col items-center justify-between p-1 text-center">
                                        <div class="title font-bold text-xs">HIGH AR:M</div>
                                        <div class="brand font-bold text-[7px] text-green-600">INTECH PRODUCT</div>
                                        <img src="<?php echo e($qrURL); ?>" alt="QR Code" class="w-16 h-16 mx-auto">
                                        <div class="scan-note text-[5px] text-gray-600">Scan to Verify Authenticity</div>
                                        <div class="serial text-[6px] text-red-600 font-bold border-t border-gray-300 pt-1 w-full">
                                            Serial: <?php echo e($serialCode); ?>

                                        </div>
                                    </div>
                                    <div class="barcode-wrapper w-4 flex items-center justify-center overflow-hidden">
                                        <img src="<?php echo e($barcodeURL); ?>" alt="Barcode" class="transform rotate-90 max-h-full">
                                    </div>
                                </div>
                            <?php endfor; ?>
                        </div>
                    </div>
                <?php endfor; ?>
            </div>
        </div>

        <style>
            @media print {
                .print-controls {
                    display: none;
                }
                body {
                    margin: 0;
                }
                @page {
                    size: A4;
                    margin: 0;
                }
                .page {
                    margin: 0;
                    page-break-after: always;
                }
            }

            .page {
                width: 210mm;
                height: 297mm;
                display: grid;
                grid-template-columns: repeat(5, 1fr);
                grid-template-rows: repeat(8, 1fr);
                gap: 0.8mm;
                padding: 1mm;
                box-sizing: border-box;
            }

            .sticker-wrapper {
                display: flex;
                align-items: stretch;
                justify-content: stretch;
                width: 100%;
                height: 100%;
            }

            .sticker {
                flex: 1;
                border: 2px solid #000;
                text-align: center;
                box-sizing: border-box;
                display: flex;
                flex-direction: column;
                justify-content: space-between;
                align-items: center;
                padding-top: 5px;
                padding-bottom: 3px;
                background: #fff;
            }

            .barcode-wrapper {
                width: 12px;
                margin-left: 1px;
                display: flex;
                align-items: center;
                justify-content: center;
                overflow: hidden;
            }

            .barcode-wrapper img {
                transform: rotate(270deg);
                transform-origin: center;
                width: 100%; /* This becomes height after rotation */
                height: auto;
                display: block;
            }
        </style>
    <?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\product-authentication-system2\resources\views/products/sticker-print.blade.php ENDPATH**/ ?>