<?php $__env->startSection('title', 'Your Shopping Cart'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .quantity-input {
        width: 4rem;
        text-align: center;
        border: 1px solid #e2e8f0;
        border-radius: 0.5rem;
    }
    .quantity-btn {
        transition: all 0.2s ease;
    }
    .quantity-btn:hover {
        transform: scale(1.1);
    }
    .pulse {
        animation: pulse 0.5s ease-in-out;
    }
    @keyframes pulse {
        0% { transform: scale(1); }
        50% { transform: scale(1.05); }
        100% { transform: scale(1); }
    }
    .toast-notification {
        animation: toast-in 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94) forwards;
    }
    @keyframes toast-in {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    @keyframes toast-out {
        from { transform: translateX(0); opacity: 1; }
        to { transform: translateX(100%); opacity: 0; }
    }
    @keyframes progress {
        from { width: 100%; }
        to { width: 0%; }
    }
    .cart-item {
        transition: all 0.3s ease;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page Title -->
    <div class="bg-gray-100 py-8 px-4">
        <div class="container mx-auto max-w-6xl">
            <h1 class="text-3xl font-bold text-gray-800">Shopping Cart</h1>
            <p class="text-gray-600 mt-2">Review your items and proceed to checkout.</p>
        </div>
    </div>

    <!-- Cart Content -->
    <section class="py-12 px-4">
        <div class="container mx-auto max-w-6xl">
            <?php if(count($cart) > 0): ?>
                <div class="flex flex-col lg:flex-row gap-8">
                    <!-- Cart Items -->
                    <div class="w-full lg:w-2/3 bg-white rounded-lg shadow-md p-6">
                        <div class="flex justify-between items-center mb-4 border-b pb-4">
                            <h2 class="text-xl font-bold" id="cart-item-count">Your Items (<?php echo e(count($cart)); ?>)</h2>
                            <button id="clear-cart" class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition duration-300 flex items-center gap-2">
                                <i class="fas fa-trash-alt"></i> Clear Cart
                            </button>
                        </div>
                        <div class="space-y-6" id="cart-items-container">
                            <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex items-center gap-4 cart-item" data-id="<?php echo e($id); ?>">
                                    <a href="<?php echo e(route('products.show', $id)); ?>" class="flex-shrink-0">
                                        <img src="<?php echo e($details['image'] ? asset('storage/' . $details['image']) : 'https://via.placeholder.com/100'); ?>" alt="<?php echo e($details['product_name']); ?>" class="w-24 h-24 object-contain rounded-lg border p-1 hover:shadow-md transition-shadow duration-300">
                                    </a>
                                    <div class="flex-grow">
                                        <a href="<?php echo e(route('products.show', $id)); ?>" class="font-semibold text-lg text-gray-800 hover:text-blue-600 transition-colors duration-300">
                                            <?php echo e($details['product_name']); ?>

                                        </a>
                                        <p class="text-gray-500 text-sm mt-1">SKU: <?php echo e($id); ?></p>
                                        <div class="mt-2">
                                            <?php if($details['discount_price']): ?>
                                                <span class="font-bold text-red-600 item-price" data-price="<?php echo e($details['discount_price']); ?>">৳<?php echo e(number_format($details['discount_price'])); ?></span>
                                                <span class="text-sm text-gray-400 line-through ml-2">৳<?php echo e(number_format($details['price'])); ?></span>
                                            <?php else: ?>
                                                <span class="font-bold text-gray-800 item-price" data-price="<?php echo e($details['price']); ?>">৳<?php echo e(number_format($details['price'])); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <button class="quantity-btn bg-gray-200 w-8 h-8 rounded-full flex items-center justify-center hover:bg-gray-300 decrease-quantity">
                                            <i class="fas fa-minus text-sm"></i>
                                        </button>
                                        <input type="number" class="quantity-input p-2" value="<?php echo e($details['quantity']); ?>" min="1">
                                        <button class="quantity-btn bg-gray-200 w-8 h-8 rounded-full flex items-center justify-center hover:bg-gray-300 increase-quantity">
                                            <i class="fas fa-plus text-sm"></i>
                                        </button>
                                    </div>
                                    <div class="text-right min-w-20">
                                        <span class="font-bold text-lg item-total">৳<?php echo e(number_format(($details['discount_price'] ?? $details['price']) * $details['quantity'])); ?></span>
                                    </div>
                                    <div>
                                        <button class="text-gray-400 hover:text-red-500 remove-from-cart" title="Remove item">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <!-- Order Summary -->
                    <div class="w-full lg:w-1/3">
                        <div class="bg-white rounded-lg shadow-md p-6 sticky top-6">
                            <h2 class="text-xl font-bold mb-4 border-b pb-4">Order Summary</h2>
                            <div class="space-y-3">
                                <div class="flex justify-between">
                                    <span>Subtotal</span>
                                    <span id="subtotal">৳<?php echo e(number_format($total)); ?></span>
                                </div>
                                <div class="flex justify-between">
                                    <span>Shipping</span>
                                    <span>Free</span>
                                </div>
                                <div class="flex justify-between font-bold text-lg border-t pt-3">
                                    <span>Total</span>
                                    <span id="total">৳<?php echo e(number_format($total)); ?></span>
                                </div>
                            </div>
                            <button class="w-full bg-blue-600 text-white font-bold py-3 mt-6 rounded-lg hover:bg-blue-700 transition duration-300">
                                Proceed to Checkout
                            </button>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <div class="text-center bg-white rounded-lg shadow-md p-12">
                    <i class="fas fa-shopping-cart text-6xl text-gray-300 mb-4"></i>
                    <h2 class="text-2xl font-bold text-gray-800">Your cart is empty</h2>
                    <p class="text-gray-500 mt-2">Looks like you haven't added anything to your cart yet.</p>
                    <a href="<?php echo e(route('products.index')); ?>" class="inline-block bg-blue-600 text-white font-bold py-3 px-6 mt-6 rounded-lg hover:bg-blue-700 transition duration-300">
                        Start Shopping
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Calculate item total
    function calculateItemTotal(item) {
        const quantity = parseInt(item.querySelector('.quantity-input').value);
        const price = parseFloat(item.querySelector('.item-price').dataset.price);
        return quantity * price;
    }

    // Update item total display
    function updateItemTotal(item) {
        const total = calculateItemTotal(item);
        item.querySelector('.item-total').textContent = `৳${numberFormat(total)}`;
        return total;
    }

    // Update cart totals
    function updateCartTotals() {
        let subtotal = 0;
        document.querySelectorAll('.cart-item').forEach(item => {
            subtotal += updateItemTotal(item);
        });

        document.getElementById('subtotal').textContent = `৳${numberFormat(subtotal)}`;
        document.getElementById('total').textContent = `৳${numberFormat(subtotal)}`;

        // Update item count
        const itemCount = document.querySelectorAll('.cart-item').length;
        document.getElementById('cart-item-count').textContent = `Your Items (${itemCount})`;

        // Update navbar cart count if exists
        const navCartCount = document.getElementById('cart-count');
        if (navCartCount) {
            navCartCount.textContent = itemCount;
        }

        return { subtotal, itemCount };
    }

    // Number formatting
    function numberFormat(number) {
        return number.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }

    // Quantity decrease buttons
    document.querySelectorAll('.decrease-quantity').forEach(button => {
        button.addEventListener('click', function() {
            const item = this.closest('.cart-item');
            const input = item.querySelector('.quantity-input');
            let quantity = parseInt(input.value);

            if (quantity > 1) {
                quantity--;
                input.value = quantity;
                updateCartItem(item, quantity);
            }
        });
    });

    // Quantity increase buttons
    document.querySelectorAll('.increase-quantity').forEach(button => {
        button.addEventListener('click', function() {
            const item = this.closest('.cart-item');
            const input = item.querySelector('.quantity-input');
            let quantity = parseInt(input.value);

            quantity++;
            input.value = quantity;
            updateCartItem(item, quantity);
        });
    });

    // Manual quantity input
    document.querySelectorAll('.quantity-input').forEach(input => {
        input.addEventListener('change', function() {
            const item = this.closest('.cart-item');
            const quantity = parseInt(this.value);

            if (quantity > 0) {
                updateCartItem(item, quantity);
            } else {
                this.value = 1;
                showNotification('Quantity must be at least 1', 'error');
            }
        });
    });

    // Update cart item via AJAX
    function updateCartItem(item, quantity) {
        const id = item.dataset.id;

        fetch('<?php echo e(route('cart.update')); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({ id, quantity })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                updateCartTotals();
                item.classList.add('pulse');
                setTimeout(() => item.classList.remove('pulse'), 500);
                showNotification('Cart updated successfully!', 'success');
            }
        })
        .catch(error => {
            console.error('Error updating cart:', error);
            showNotification('Error updating cart', 'error');
        });
    }

    // Remove item
    document.querySelectorAll('.remove-from-cart').forEach(button => {
        button.addEventListener('click', function() {
            const item = this.closest('.cart-item');
            const id = item.dataset.id;

            if (confirm('Are you sure you want to remove this item?')) {
                fetch('<?php echo e(route('cart.remove')); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    },
                    body: JSON.stringify({ id })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Animate removal
                        item.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                        item.style.opacity = '0';
                        item.style.transform = 'translateX(100px)';

                        setTimeout(() => {
                            item.remove();
                            const { subtotal, itemCount } = updateCartTotals();

                            // Show empty cart if no items left
                            if (itemCount === 0) {
                                showEmptyCart();
                            }

                            showNotification('Item removed from cart.', 'success');
                        }, 500);
                    }
                })
                .catch(error => {
                    console.error('Error removing item:', error);
                    showNotification('Error removing item', 'error');
                });
            }
        });
    });

    // Clear cart
    const clearCartBtn = document.getElementById('clear-cart');
    if (clearCartBtn) {
        clearCartBtn.addEventListener('click', function() {
            if (confirm('Are you sure you want to clear your entire cart?')) {
                fetch('<?php echo e(route('cart.clear')); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Animate all items removal
                        const items = document.querySelectorAll('.cart-item');
                        items.forEach((item, index) => {
                            item.style.transition = `opacity 0.5s ease ${index * 100}ms, transform 0.5s ease ${index * 100}ms`;
                            item.style.opacity = '0';
                            item.style.transform = 'translateX(100px)';
                        });

                        setTimeout(() => {
                            document.getElementById('cart-items-container').innerHTML = '';
                            showEmptyCart();
                            showNotification('Cart cleared successfully!', 'success');
                        }, 500 + (items.length * 100));
                    }
                })
                .catch(error => {
                    console.error('Error clearing cart:', error);
                    showNotification('Error clearing cart', 'error');
                });
            }
        });
    }

    // Show empty cart state
    function showEmptyCart() {
        const cartContainer = document.querySelector('.container.mx-auto.max-w-6xl');
        cartContainer.innerHTML = `
            <div class="text-center bg-white rounded-lg shadow-md p-12">
                <i class="fas fa-shopping-cart text-6xl text-gray-300 mb-4"></i>
                <h2 class="text-2xl font-bold text-gray-800">Your cart is empty</h2>
                <p class="text-gray-500 mt-2">Looks like you haven't added anything to your cart yet.</p>
                <a href="<?php echo e(route('products.index')); ?>" class="inline-block bg-blue-600 text-white font-bold py-3 px-6 mt-6 rounded-lg hover:bg-blue-700 transition duration-300">
                    Start Shopping
                </a>
            </div>
        `;
    }

    // Notification function
    function showNotification(message, type = 'info') {
        document.querySelectorAll('.toast-notification').forEach(n => n.remove());

        const notification = document.createElement('div');
        notification.className = 'toast-notification fixed top-5 right-5 w-full max-w-sm bg-white shadow-2xl rounded-xl p-4 border-l-4 z-[1000]';

        const icons = { success: 'fa-check-circle', error: 'fa-exclamation-circle', info: 'fa-info-circle' };
        const borderColors = { success: 'border-green-500', error: 'border-red-500', info: 'border-blue-500' };
        const textColors = { success: 'text-green-500', error: 'text-red-500', info: 'text-blue-500' };

        notification.classList.add(borderColors[type] || borderColors.info);

        notification.innerHTML = `
            <div class="flex items-start gap-4">
                <i class="fas ${icons[type] || icons.info} ${textColors[type] || textColors.info} text-2xl mt-1"></i>
                <div class="flex-1">
                    <p class="font-bold text-gray-800">${type.charAt(0).toUpperCase() + type.slice(1)}</p>
                    <p class="text-sm text-gray-600">${message}</p>
                </div>
                <button class="v-alert-close text-gray-400 hover:text-gray-600">&times;</button>
            </div>
            <div class="absolute bottom-0 left-0 h-1 bg-gray-200 rounded-bl-lg">
                <div class="h-1 ${borderColors[type] ? borderColors[type].replace('border', 'bg') : 'bg-blue-500'} rounded-bl-lg" style="width: 100%; animation: progress 4s linear forwards;"></div>
            </div>
        `;

        document.body.appendChild(notification);
        notification.style.animation = 'toast-in 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94) forwards';

        const close = () => {
            notification.style.animation = 'toast-out 0.5s ease-in forwards';
            notification.addEventListener('animationend', () => notification.remove(), { once: true });
        };

        const timer = setTimeout(close, 4000);

        notification.querySelector('.v-alert-close').addEventListener('click', () => {
            clearTimeout(timer);
            close();
        });
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Product-Verify-Auth-Application\resources\views/frontend/pages/cart.blade.php ENDPATH**/ ?>