import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

const colorSafelist = [
    'blue',
    'purple',
    'green',
    'yellow',
    'red',
    'indigo',
].flatMap((color) => [`from-${color}-500`, `to-${color}-600`, `from-${color}-600`, `to-${color}-700`, `bg-${color}-100`, `text-${color}-800`]);

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/js/**/*.js',
        './resources/views/**/*.blade.php',
    ],
    safelist: [
        'bg-gradient-to-r',
        ...colorSafelist,
        // Status badge colors for dynamic classes
        'bg-blue-100', 'text-blue-800',
        'bg-yellow-100', 'text-yellow-800',
        'bg-green-100', 'text-green-800',
        'bg-purple-100', 'text-purple-800',
        'bg-red-100', 'text-red-800',
        'bg-gray-100', 'text-gray-800',
    ],

    theme: {
        extend: {
            colors: {
                'primary': 'rgb(var(--color-primary) / <alpha-value>)',
                'secondary': 'rgb(var(--color-secondary) / <alpha-value>)',
            },
            fontFamily: {
                sans: ['Figtree', ...defaultTheme.fontFamily.sans],
            },
        },
    },

    plugins: [forms],
};
